#include "elf.h"
#include "ext2.h"
#include "mm.h"
#include "lib.h"
#include "kmalloc.h"

/* 
 * Teste si le fichier dont l'adresse est passee en argument
 * est au format ELF
 */
int is_elf(char *file)
{
	Elf32_Ehdr *hdr;

	hdr = (Elf32_Ehdr *) file;
	if (hdr->e_ident[0] == 0x7f && hdr->e_ident[1] == 'E'
	    && hdr->e_ident[2] == 'L' && hdr->e_ident[3] == 'F')
		return 1;
	else
		return 0;
}

u32 load_elf(char *file, struct page_directory * pd, struct page_list * mmap)
{
	char *p;
	u32 v_begin, v_end, v_addr;
	Elf32_Ehdr *hdr;
	Elf32_Phdr *p_entry;
	int i, pe;

	hdr = (Elf32_Ehdr *) file;
	p_entry = (Elf32_Phdr *) (file + hdr->e_phoff);	/* Program header table offset */

	if (!is_elf(file)) {
		printk("INFO: load_elf(): file not in ELF format !\n");
		return 0;
	}

	for (pe = 0; pe < hdr->e_phnum; pe++, p_entry++) {	/* Read each entry */

		if (p_entry->p_type == PT_LOAD) {
			v_begin = p_entry->p_vaddr;
			v_end = p_entry->p_vaddr + p_entry->p_memsz;

			/* 
			 * Allocation memoire mappee sur l'espace d'adressage
			 * utilisateur 
			 */
			for (v_addr = v_begin; v_addr < v_end; v_addr += PAGESIZE) {

				if (v_addr < USER_OFFSET) {
					printk ("File can't load exec below %p\n", USER_OFFSET);
					return 0;
				}

				if (v_addr > USER_STACK) {
					printk ("File can't load exec above %p\n", USER_STACK);
					return 0;
				}

				if (get_p_addr((char *) v_addr) == 0) {
					if (mmap->page) {
						mmap->next = (struct page_list *) kmalloc(sizeof (struct page_list));
						mmap->next->next = 0;
						mmap->next->prev = mmap;
						mmap = mmap->next;
					}
					mmap->page = (struct page *) kmalloc(sizeof(struct page));
					mmap->page->p_addr = get_page_frame();
					mmap->page->v_addr = (char *) (v_addr & 0xFFFFF000);
					pd_add_page((char *) (v_addr & 0xFFFFF000), mmap->page->p_addr, PG_USER, pd);
				}
			}

			memcpy((char *) v_begin, (char *) (file + p_entry->p_offset), p_entry->p_filesz);
			if (p_entry->p_memsz > p_entry->p_filesz)
				for (i = p_entry->p_filesz, p = (char *) p_entry->p_vaddr; i < p_entry->p_memsz; i++)
					p[i] = 0;
		}
	}

	/* Return program entry point */
	return hdr->e_entry;
}
