#include "types.h"
#include "lib.h"
#include "gdt.h"
#include "screen.h"
#include "io.h"
#include "idt.h"
#include "mm.h"
#include "process.h"
#include "boot.h"
#include "disk.h"
#include "kmalloc.h"
#include "ext2.h"


void ok_msg(void)
{
	kX = 40;
	kattr = 0x0A;
	printk("OK\n");
	kattr = 0x07;
}

void task1(void)
{
	char *msg = (char *) 0x40001000;
	int i;

	msg[0] = 't';
	msg[1] = 'a';
	msg[2] = 's';
	msg[3] = 'k';
	msg[4] = '1';
	msg[5] = '\n';
	msg[6] = 0;

	while (1) {
		asm("mov %0, %%ebx; mov $0x01, %%eax; int $0x30":: "m"(msg));
		for (i = 0; i < 1000000; i++);
	}

	return;			/* never go there */
}

void task2(void)
{
	char *msg = (char *) 0x40001000;
	int i;

	msg[0] = 't';
	msg[1] = 'a';
	msg[2] = 's';
	msg[3] = 'k';
	msg[4] = '2';
	msg[5] = '\n';
	msg[6] = 0;

	while (1) {
		asm("mov %0, %%ebx; mov $0x01, %%eax; int $0x30":: "m"(msg));
		for (i = 0; i < 1000000; i++);
	}

	return;			/* never go there */
}

void kmain(struct multiboot_info *mbi)
{
	printk("Pepin is booting...\n");
	printk("RAM detected : %uk (lower), %uk (upper)\n", mbi->low_mem, mbi->high_mem);

	cli;

	/* Initialisation de la GDT et des segments */
	printk("Loading GDT");
	init_gdt();
	asm("	movw $0x18, %%ax \n \
		movw %%ax, %%ss \n \
		movl %0, %%esp"::"i" (KERN_STACK));
	ok_msg();

	printk("Loading IDT");
	init_idt();
	ok_msg();

	printk("Configure PIC");
	init_pic();
	ok_msg();

	printk("Loading Task Register");
	asm("	movw $0x38, %ax; ltr %ax");
	ok_msg();

	printk("Enabling paging");
	init_mm(mbi->high_mem);
	ok_msg();

	/* Initialise le thread kernel */
	current = &p_list[0];
	current->pid = 0;
	current->state = 1;
	current->regs.cr3 = (u32) pd0;

	load_task((char *) &task1, 0x2000);
	load_task((char *) &task2, 0x2000);

	{
		char *mmap;
		int i;

		struct disk *hd;
		struct ext2_inode *inode;

		kattr = 0x47;
		printk("\nTesting Ext2\n");
		kattr = 0x07;

		/*
		 * On alloue une structure pour stocker les informations
		 * relative au filesysteme
		 * Note : la fonction ext2_get_disk_info() fait lit le superbloc et le
		 * tableau des descripteurs de groupes.
		 */
		hd = ext2_get_disk_info(0);

		/* 
		 * On affiche ensuite quelques infos.
		 */
		kattr = 0x0E;
		printk("Group descriptor info for group[0]:\n");
		kattr = 0x07;
		printk("free blocks: %d, free inodes: %d\n",
		     hd->gd[0].bg_free_blocks_count, hd->gd[0].bg_free_inodes_count);

		/*
		 * Lecture d'une inode
		 */
		kattr = 0x0E;
		printk("Infos about inode 14:\n");
		kattr = 0x07;
		inode = ext2_read_inode(hd, 14);
		printk
		    ("i_mode: %4x, i_uid: %d, i_gid: %d, i_size:%d, i_links_count:%d\n",
		     inode->i_mode, inode->i_uid, inode->i_gid, inode->i_size, inode->i_links_count);

		/*
		 * Lecture et affichage du fichier associe a cette inode
		 */
		kattr = 0x0E;
		printk("File content (inode 14) :\n");
		kattr = 0x07;
		mmap = ext2_read_file(hd, inode);
		for (i = 0; i < inode->i_size; i++)
			putcar(mmap[i]);
		printk("\n");

		hide_cursor();
		asm("hlt");
	}

}
