
#include "types.h"
#include "io.h"
#include "lib.h"
#include "mm.h"
#include "kmalloc.h"
#include "ext2.h"
#include "elf.h"
#include "file.h"

#define __PLIST__
#include "process.h"


/*
 * Charge une tache en memoire
 */
int load_task(struct disk *hd, struct ext2_inode *inode)
{
	struct page_directory *pd;
	struct page_list *pglist;
	struct page *kstack;

	char *file;
	char *ustack;
	u32 e_entry;

	int pid;

	/* 
	 * Calcul du pid du nouveau processus. Assume qu'on n'atteindra jamais
	 * la limite imposee par la taille de p_list[]
	 * FIXME: reutiliser slots libres
	 */
	pid = 1;
	while (p_list[pid].state != 0 && pid++ < MAXPID);

	if (p_list[pid].state != 0) {
		printk("PANIC: not enough slot for processes\n");
		return 0;
	}

	/* Cree un repertoire de pages */
	pd = pd_create();

	/* 
	 * On change d'espace d'adressage pour passer sur ce nouveau repertoire
	 * de pages. Cette astuce permet de le mettre a jour facilement en
	 * utilisant la fonction pd_add_page() 
	 */
	asm("mov %0, %%eax; mov %%eax, %%cr3"::"m"(pd->base->p_addr));

	/* 
	 * Charge le fichier et l'executable en memoire
	 */
	file = ext2_read_file(hd, inode);
	pglist = (struct page_list *) kmalloc(sizeof(struct page_list));
	pglist->page = 0;
	pglist->next = 0;
	pglist->prev = 0;
	e_entry = (u32) load_elf(file, pd, pglist);
	kfree(file);
	if (e_entry == 0) {
		asm("mov %0, %%eax ;mov %%eax, %%cr3"::"m" (current->regs.cr3));
		pd_destroy(pd);
		return 0;
	}

	/* Cree la pile utilisateur */
	ustack = get_page_frame();
	pd_add_page((char *) USER_STACK, ustack, PG_USER, pd);

	/* Cree la pile noyau */
	kstack = get_page_from_heap();

	n_proc++;

	p_list[pid].pid = pid;

	/* Initialise les registres */
	p_list[pid].regs.ss = 0x33;
	p_list[pid].regs.esp = USER_STACK + PAGESIZE - 16;
	p_list[pid].regs.eflags = 0x0;
	p_list[pid].regs.cs = 0x23;
	p_list[pid].regs.eip = e_entry;
	p_list[pid].regs.ds = 0x2B;
	p_list[pid].regs.es = 0x2B;
	p_list[pid].regs.fs = 0x2B;
	p_list[pid].regs.gs = 0x2B;
	p_list[pid].regs.cr3 = (u32) pd->base->p_addr;

	p_list[pid].kstack.ss0 = 0x18;
	p_list[pid].kstack.esp0 = (u32) kstack->v_addr + PAGESIZE - 16;

	p_list[pid].regs.eax = 0;
	p_list[pid].regs.ecx = 0;
	p_list[pid].regs.edx = 0;
	p_list[pid].regs.ebx = 0;

	p_list[pid].regs.ebp = 0;
	p_list[pid].regs.esi = 0;
	p_list[pid].regs.edi = 0;

	p_list[pid].pd = pd;
	p_list[pid].pglist = pglist;

	p_list[pid].pwd = f_root;

	p_list[pid].fd = 0;	/* Aucun fichier ouvert */

	p_list[pid].state = 1;

	asm("mov %0, %%eax ;mov %%eax, %%cr3":: "m"(current->regs.cr3));

	return pid;
}
