#include "types.h"
#include "lib.h"
#include "gdt.h"
#include "screen.h"
#include "io.h"
#include "idt.h"

void init_pic(void);


int main(void);

void _start(void)
{
	kY = 16;
	kattr = 0x0E;

	/* Initialisation de la GDT et des segments */
	init_gdt();

	/* Initialisation du pointeur de pile %esp */
	asm("   movw $0x18, %ax \n \
                movw %ax, %ss \n \
                movl $0x20000, %esp");

	main();
}

int main(void)
{
	print("kernel : gdt loaded\n");

	init_idt();
	print("kernel : idt loaded\n");

	init_pic();
	print("kernel : pic configured\n");

	hide_cursor();

	/* Initialisation du TSS */
	asm("	movw $0x38, %ax \n \
		ltr %ax");
	print("kernel : tr loaded\n");

	/* Initialisation de la memoire */
	init_mm();
	kattr = 0x47;
	print("kernel : paging enable\n");
	kattr = 0x0E;

	sti;
	print("kernel : interrupts enable\n");
	kattr = 0x07;

	while (1);
}
