#include "types.h"
#include "lib.h"
#include "gdt.h"
#include "screen.h"
#include "io.h"
#include "idt.h"
#include "mm.h"
#include "process.h"
#include "boot.h"
#include "disk.h"
#include "kmalloc.h"
#include "ext2.h"
#include "elf.h"

void ok_msg(void)
{
	kX = 40;
	kattr = 0x0A;
	printk("OK\n");
	kattr = 0x07;
}

void kmain(struct multiboot_info *mbi)
{
	int i, j;

	printk("Pepin is booting...\n");
	printk("RAM detected : %uk (lower), %uk (upper)\n", mbi->low_mem, mbi->high_mem);

	cli;

	/* Initialisation de la GDT et des segments */
	printk("Loading GDT");
	init_gdt();
	asm("	movw $0x18, %%ax \n \
		movw %%ax, %%ss \n \
		movl %0, %%esp"::"i" (KERN_STACK));
	ok_msg();

	printk("Loading IDT");
	init_idt();
	ok_msg();

	printk("Configure PIC");
	init_pic();
	ok_msg();

	printk("Loading Task Register");
	asm("	movw $0x38, %ax; ltr %ax");
	ok_msg();

	printk("Enabling paging");
	init_mm(mbi->high_mem);
	ok_msg();

	{
		struct disk *hd;
		struct ext2_inode *inode;

		/*
		 * On alloue une structure pour stocker les informations
		 * relative au filesysteme
		 */
		hd = ext2_get_disk_info(0);

		/* Initialise le thread kernel */
		current = &p_list[0];
		current->pid = 0;
		current->state = 1;
		current->regs.cr3 = (u32) pd0;

		/* Lecture et chargement des fichiers executables correspondant
 	         * aux inodes 13 et 14 
		 */
		inode = ext2_read_inode(hd, 13);
		load_task(hd, inode);

		inode = ext2_read_inode(hd, 14);
		load_task(hd, inode);

		kattr = 0x47;
		printk("Interrupts are enable. System is ready !\n\n");
		kattr = 0x07;
		hide_cursor();

		sti;

		j = 0;
		while (1) {
			printk("Kernel: %d process running\n", n_proc);
			for (i = 0; i < 10000000; i++);
		}
	}

}
