#include "types.h"
#include "lib.h"
#include "io.h"
#include "process.h"
#include "kmalloc.h"
#include "mm.h"
#include "schedule.h"

void do_syscalls(int sys_num)
{
	/* print console */
	if (sys_num == 1) {
		char *u_str;
		int i;

		asm("mov %%ebx, %0": "=m"(u_str):);
		for (i = 0; i < 100000; i++);	/* temporisation */

		cli;
		printk(u_str);
		sti;
	}

	/* exit */
	else if (sys_num == 2) {
		u16 kss;
		u32 kesp;
		struct page_list *pl, *oldpl;

		cli;

		n_proc--;
		current->state = 0;

		/* 
		 * Liberation des ressources memoire allouees au processus :
		 *   - les pages utilisees par le code executable
		 *   - la pile utilisateur
		 *   - la pile noyau
		 *   - le repertoire et les tables de pages
		 */

		/* Libere la memoire occupee par l'executable */
		pl = current->pglist;
		while (pl) {
			release_page_frame(pl->page->p_addr);
			kfree(pl->page);
			oldpl = pl;
			pl = pl->next;
			kfree(oldpl);
		}

		/* Libere la pile utilisateur */
		release_page_frame((u32) get_p_addr((char *) USER_STACK));	

		/* Libere la pile noyau */
		kss = p_list[0].regs.ss;
		kesp = p_list[0].regs.esp;
		asm("mov %0, %%ss; mov %1, %%esp;"::"m"(kss), "m"(kesp));
		release_page_from_heap((char *) ((u32) current->kstack.esp0 & 0xFFFFF000));

		/* Libere le repertoire et les tables de pages */
		asm("mov %0, %%eax; mov %%eax, %%cr3"::"m"(pd0));
		pd_destroy(current->pd);

		switch_to_task(0, KERNELMODE);
	}

	/* dump regs */
	else if (sys_num == 3) {
		u32 *pa;

		asm("mov %%ebp, %0": "=m"(pa):);

		printk("eax: %p ecx: %p edx: %p ebx: %p\n", pa[12], pa[11], pa[10], pa[9]);
		printk("ds: %p esi: %p edi: %p\n", pa[4], pa[6], pa[5]);
		printk("ss: %p ebp: %p esp: %p\n", pa[17], pa[7], pa[16]);
		printk("cs: %p eip: %p\n", pa[14], pa[13]);
	}

	else
		printk("unknown syscall %d\n", sys_num);

	return;
}
