#include "types.h"
#include "lib.h"
#include "io.h"
#include "process.h"
#include "kmalloc.h"
#include "mm.h"
#include "schedule.h"
#include "file.h"

void do_syscalls(int sys_num)
{
	u32 *stack_ptr;

	/* 
	 * Stocke dans stack_ptr le pointeur vers les registres sauvegardes.
	 * Les arguments sont transmis dans : ebx, ecx, edx, esi edi
	 * Le code de retour sera transmis dans %eax : stack_ptr[14]
	 */
	asm("mov %%ebp, %0": "=m"(stack_ptr):);

	/* print console */
	if (sys_num == 1) {
		char *u_str;
		int i;

		asm("mov %%ebx, %0": "=m"(u_str):);
		for (i = 0; i < 100000; i++);	/* temporisation */

		cli;
		printk(u_str);
		sti;
	}

	/* exit */
	else if (sys_num == 2) {
		u16 kss;
		u32 kesp;
		struct page_list *pl, *oldpl;
		struct open_file *fd, *fdn;

		cli;

		printk("DEBUG: sys_exit(): process[%d] exit\n", current->pid);     /* DEBUG */

		n_proc--;
		current->state = 0;

		/* 
		 * Liberation des ressources memoire allouees au processus :
		 *   - les pages utilisees par le code executable
		 *   - la pile utilisateur
		 *   - la pile noyau
		 *   - le repertoire et les tables de pages
		 */

		/* Libere la memoire occupee par l'executable */
		pl = current->pglist;
		while (pl) {
			release_page_frame(pl->page->p_addr);
			kfree(pl->page);
			oldpl = pl;
			pl = pl->next;
			kfree(oldpl);
		}

		/* Libere la pile utilisateur */
		release_page_frame((u32) get_p_addr((char *) USER_STACK));

		/* Libere la pile noyau */
		kss = p_list[0].regs.ss;
		kesp = p_list[0].regs.esp;
		asm("mov %0, %%ss; mov %1, %%esp;"::"m"(kss), "m"(kesp));
		release_page_from_heap((char *) ((u32) current->kstack.esp0 & 0xFFFFF000));

		/* Libere la liste des fichiers ouverts */
		fd = current->fd;
		while (fd) {
			/* Libere le fichier si plus aucun processus ne pointe dessus */
			fd->file->opened--;
			if (fd->file->opened == 0) {
				kfree(fd->file->mmap);
				fd->file->mmap = 0;
			}

			fdn = fd->next;
			kfree(fd);
			fd = fdn;
		}

		/* Libere le repertoire de pages et les tables associees */
		asm("mov %0, %%eax; mov %%eax, %%cr3"::"m"(pd0));
		pd_destroy(current->pd);

		switch_to_task(0, KERNELMODE);
	}

	/* file open */
	else if (sys_num == 3) {
		char *path;
		u32 fd;
		struct file *fp;
		struct open_file *of;

		asm("mov %%ebx, %0": "=m"(path):);

		if (!(fp = path_to_file(path))) {
			printk("can't chdir to %s\n", path);
			return;
		}

		printk("DEBUG: sys_open(): process[%d] opening file %s\n", current->pid, fp->name);
		
		fp->opened++;

		if (!fp->inode)
			fp->inode = ext2_read_inode(fp->disk, fp->inum);

		/* Lecture du fichier */
		fp->mmap = ext2_read_file(fp->disk, fp->inode);

		/* 
		 * Recherche d'un descripteur libre.
		 */
		fd = 0;
		if (current->fd == 0) {
			current->fd = (struct open_file *) kmalloc(sizeof(struct open_file));
			current->fd->file = fp;
			current->fd->ptr = 0;
			current->fd->next = 0;
		} else {
			of = current->fd;
			while (of->file && of->next) {
				of = of->next;
				fd++;
			}

			if (of->file == 0) {	/* reutilisation d'un descripteur precedement ouvert */
				of->file = fp;
				of->ptr = 0;
			} else {		/* nouveau descripteur */
				of->next = (struct open_file *) kmalloc(sizeof(struct open_file));
				of->next->file = fp;
				of->next->ptr = 0;
				of->next->next = 0;
				fd++;
			}
		}

		stack_ptr[14] = fd;
	}

	/* file read */
	else if (sys_num == 4) {
		char *u_buf;	/* buffer d'entree utilisateur */
		u32 fd;
		u32 bufsize;
		struct open_file *of;

		asm("	mov %%ebx, %0;	\
			mov %%ecx, %1;	\
			mov %%edx, %2": "=m"(fd), "=m"(u_buf), "=m"(bufsize):);

		//// printk("DEBUG: sys_read(): reading %d bytes on fd %d\n", bufsize, fd);

		of = current->fd;
		while (fd) {
			of = of->next;
			if (of == 0) {
				printk ("ERROR: sys_read(): invalid file descriptor\n");
				return;
			}
			fd--;
		}

		if ((of->ptr + bufsize) > of->file->inode->i_size)
			bufsize = of->file->inode->i_size - of->ptr;

		memcpy(u_buf, (char *) (of->file->mmap + of->ptr), bufsize);
		of->ptr += bufsize;

		stack_ptr[14] = bufsize;
	}

	/* file close */
	else if (sys_num == 5) {
		u32 fd;
		struct open_file *of;

		asm("mov %%ebx, %0": "=m"(fd):);

		printk("DEBUG: sys_close(): process[%d] closing fd %d\n", current->pid, fd);

		of = current->fd;
		while (fd) {
			of = of->next;
			if (of == 0) {
				printk("ERROR: sys_close(): invalid file descriptor\n");
				return;
			}
			fd--;
		}

		kfree(of->file->mmap);
		of->file->mmap = 0;
		of->file = 0;
		of->ptr = 0;
	}

	else if (sys_num == 10) {
		u32 *pa;
		asm("mov %%ebp, %0": "=m"(pa):);
		printk("eax: %p ecx: %p edx: %p ebx: %p\n", pa[12], pa[11], pa[10], pa[9]);
		printk("ds: %p esi: %p edi: %p\n", pa[4], pa[6], pa[5]);
		printk("ss: %p ebp: %p esp: %p\n", pa[17], pa[7], pa[16]);
		printk("cs: %p eip: %p\n", pa[14], pa[13]);
	}

	else
		printk("unknown syscall %d\n", sys_num);

	return;
}
