#include "elf.h"
#include "ext2.h"
#include "mm.h"
#include "lib.h"
#include "kmalloc.h"

/* 
 * Teste si le fichier dont l'adresse est passee en argument
 * est au format ELF
 */
int is_elf(char *file)
{
	Elf32_Ehdr *hdr;

	hdr = (Elf32_Ehdr *) file;
	if (hdr->e_ident[0] == 0x7f && hdr->e_ident[1] == 'E'
	    && hdr->e_ident[2] == 'L' && hdr->e_ident[3] == 'F')
		return 1;
	else
		return 0;
}

u32 load_elf(char *file, struct page_directory * pd, struct list_head *pglist)
{
	char *p;
	u32 v_begin, v_end, v_addr;
	Elf32_Ehdr *hdr;
	Elf32_Phdr *p_entry;
	struct page *pg;
	int i, pe;

	hdr = (Elf32_Ehdr *) file;
	p_entry = (Elf32_Phdr *) (file + hdr->e_phoff);	/* Program header table offset */

	if (!is_elf(file)) {
		printk("INFO: load_elf(): file not in ELF format !\n");
		return 0;
	}

	for (pe = 0; pe < hdr->e_phnum; pe++, p_entry++) {	/* Read each entry */

		if (p_entry->p_type == PT_LOAD) {
			v_begin = p_entry->p_vaddr;
			v_end = p_entry->p_vaddr + p_entry->p_memsz;

			/* 
			 * Allocation memoire mappee sur l'espace d'adressage
			 * utilisateur 
			 */
			for (v_addr = v_begin; v_addr < v_end; v_addr += PAGESIZE) {

				if (v_addr < USER_OFFSET) {
					printk ("INFO: load_elf(): can't load executable below %p\n", USER_OFFSET);
					return 0;
				}

				if (v_addr > USER_STACK) {
					printk ("INFO: load_elf(): can't load executable above %p\n", USER_STACK);
					return 0;
				}

				if (get_p_addr((char *) v_addr) == 0) {
					pg = (struct page *) kmalloc(sizeof(struct page));
					pg->p_addr = get_page_frame();
					pg->v_addr = (char *) (v_addr & 0xFFFFF000);
					list_add(&pg->list, pglist);
					pd_add_page(pg->v_addr, pg->p_addr, PG_USER, pd);
				}
			}

			memcpy((char *) v_begin, (char *) (file + p_entry->p_offset), p_entry->p_filesz);

			if (p_entry->p_memsz > p_entry->p_filesz)
				for (i = p_entry->p_filesz, p = (char *) p_entry->p_vaddr; i < p_entry->p_memsz; i++)
					p[i] = 0;
		}
	}

	/* Return program entry point */
	return hdr->e_entry;
}
