#include "types.h"
#include "io.h"
#include "lib.h"
#include "mm.h"
#include "kmalloc.h"
#include "ext2.h"
#include "elf.h"
#include "file.h"
#include "list.h"

#define __PLIST__
#include "process.h"


/*
 * Charge une tache en memoire
 */
int load_task(struct disk *hd, struct ext2_inode *inode)
{
	struct page *kstack;

	char *file;
	char *ustack;
	u32 e_entry;

	int pid;

	/* 
	 * Calcul du pid du nouveau processus. Assume qu'on n'atteindra jamais
	 * la limite imposee par la taille de p_list[]
	 * FIXME: reutiliser slots libres
	 */
	pid = 1;
	while (p_list[pid].state != 0 && pid++ < MAXPID);
	if (p_list[pid].state != 0) {
		printk("PANIC: not enough slot for processes\n");
		return 0;
	}

	n_proc++;
	p_list[pid].pid = pid;

	/* Cree un repertoire de pages */
	p_list[pid].pd = pd_create();

	/* Initialise la liste des pages frame utilisees */
	INIT_LIST_HEAD(&p_list[pid].pglist);

	/* 
	 * On change d'espace d'adressage pour passer sur celui du nouveau
	 * processus.
	 */
	asm("mov %0, %%eax; mov %%eax, %%cr3"::"m"(p_list[pid].pd->base->p_addr));

	/* 
	 * Charge l'executable en memoire. En cas d'echec, on libere les
	 * ressources precedement allouees.
	 */
	file = ext2_read_file(hd, inode);
	e_entry = (u32) load_elf(file, p_list[pid].pd, &p_list[pid].pglist);
	kfree(file);
	if (e_entry == 0) {	/* echec */
		asm("mov %0, %%eax ;mov %%eax, %%cr3"::"m" (current->regs.cr3));
		pd_destroy(p_list[pid].pd);
		return 0;
	}

	/* 
	 * Cree la pile utilisateur 
	 * FIXME: la pile n'occupe qu'une seule page !
	 */
	ustack = get_page_frame();
	pd_add_page((char *) USER_STACK, ustack, PG_USER, p_list[pid].pd);

	/* Cree la pile noyau */
	kstack = get_page_from_heap();

	/* Initialise le reste des registres et des attributs */
	p_list[pid].regs.ss = 0x33;
	p_list[pid].regs.esp = USER_STACK + PAGESIZE - 16;
	p_list[pid].regs.eflags = 0x0;
	p_list[pid].regs.cs = 0x23;
	p_list[pid].regs.eip = e_entry;
	p_list[pid].regs.ds = 0x2B;
	p_list[pid].regs.es = 0x2B;
	p_list[pid].regs.fs = 0x2B;
	p_list[pid].regs.gs = 0x2B;
	p_list[pid].regs.cr3 = (u32) p_list[pid].pd->base->p_addr;

	p_list[pid].kstack.ss0 = 0x18;
	p_list[pid].kstack.esp0 = (u32) kstack->v_addr + PAGESIZE - 16;

	p_list[pid].regs.eax = 0;
	p_list[pid].regs.ecx = 0;
	p_list[pid].regs.edx = 0;
	p_list[pid].regs.ebx = 0;

	p_list[pid].regs.ebp = 0;
	p_list[pid].regs.esi = 0;
	p_list[pid].regs.edi = 0;

	/* p_list[pid].pd; */
	/* p_list[pid].pglist; */

	p_list[pid].pwd = f_root;

	p_list[pid].fd = 0;	/* Aucun fichier ouvert */

	p_list[pid].state = 1;

	asm("mov %0, %%eax ;mov %%eax, %%cr3":: "m"(current->regs.cr3));

	return pid;
}
